# Hello Job On-Submission script
#
# The job introduces itself and asks for the user approval.
# Exits the submission if not approved


# progress bar B is used for all jobs
if rr.perJobCurrent() == 0:
    rrGlobal.progress_SetMaxB(rr.perJobMax())
rrGlobal.progress_SetProgressB(rr.perJobCurrent())

# progress bar A is used for this script
rrGlobal.progress_SetMaxA(5)
rrGlobal.progress_SetProgressA(0)
rrGlobal.refreshUI()

job = rr.getJob()
print("I am job " +job.sceneName)
rrGlobal.progress_SetProgressA(1)

rrGlobal.writeLog2(rrGlobal.logLvL.info, "I am job " + job.sceneName)
rrGlobal.progress_SetProgressA(2)

# Simple Message
rrGlobal.messageBox(rrGlobal.logLvL.info, "I am job " + job.sceneName)
rrGlobal.progress_SetProgressA(3)

# Two buttons dialog: clicking "NO" aborts the submission with an error
msgRet = rrGlobal.messageBox(rrGlobal.logLvL.info, "Do you like me?", "Yes", "No", False, 30)

if msgRet == 0:  # 0: Button 2 ("No") was clicked, 1: Button 1 was clicked
    rrGlobal.writeLog2(rrGlobal.logLvL.info, job.sceneName)
    # any exception other than rrCleanExit exits the script AND the submission
    raise Exception("User dislikes the job")

# Final Dialog, clicking "No" will exit the script and submit the scene
msgRet = rrGlobal.messageBox(rrGlobal.logLvL.info,
                             "Should I update the progress bars before submitting?",
                             "Yes", "No", False, 30)
if msgRet == 0:
    raise rrCleanExit()  # rrCleanExit will exit the script, but NOT the submission

# Update progress and exit
import time
time.sleep(0.5)
rrGlobal.progress_SetProgressA(4)
print(msgRet)
time.sleep(0.5)
rrGlobal.progress_SetProgressA(5)


# Required if you have changed settings and you want to update the job:
# rr.setJob(job)

